package com.ejie.ab18a.consulta;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ejie.ab18a.modelo.Ab18aConfiguracionAplicacion;
import com.ejie.ab18a.modelo.Ab18aIncoherencia;
import com.ejie.ab18a.modelo.Ab18aPeticionEnvio;
import com.ejie.ab18a.modelo.Ab18aPlantillasXSLT;
import com.ejie.ab18a.modelo.Ab18aRespuestaWS;
import com.ejie.ab18a.properties.Ab18aPropertiesBatchManager;
import com.ejie.ab18a.utilidades.Ab18aConexionOracle;
import com.ejie.ab18a.utilidades.Ab18aConstantes;
import com.ejie.ab18a.utilidades.Ab18aException;
import com.ejie.ab18a.utilidades.Ab18aSentenciaOracle;

import eu.europa.ec.publications.esentool.rest.client.NoticeInformation;
import eu.europa.ec.publications.esentool.rest.client.PublicationInfo;
import eu.europa.ec.publications.esentool.rest.client.ValidationReportItem;

/**
 * The Class Ab18aRealizarProcesoBD.
 * 
 * @author XXXX
 */
public class Ab18aRealizarProcesoBD {

	/** The instancia. */
	private static Ab18aRealizarProcesoBD instancia = new Ab18aRealizarProcesoBD();

	/**
	 * El constructor privado no permite que se genere un constructor por
	 * defecto (con mismo modificador de acceso que la definición de la clase).
	 */
	private Ab18aRealizarProcesoBD() {
	}

	/**
	 * Instacia de la clase.
	 * 
	 * @return Y46jRealizarProcesoBD Y46jRealizarProcesoBD
	 */
	public static Ab18aRealizarProcesoBD getInstance() {
		return Ab18aRealizarProcesoBD.instancia;
	}

	public void almacenarEnvioBoletin(Connection connectionOracle, NoticeInformation notice, int idPeticionEnvio) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "almacenarEnvioBoletin";
		StringBuffer query = new StringBuffer();
		try {

			query.append("INSERT INTO AB18A13T00");
			query.append("(T01_ID_PETICION_ENVIO, T13_ID_ENVIO_WS");
			query.append(", T13_FECHA_RECEP_WS, T13_ESTADO_ENVIO_WS");
			query.append(", T13_ERROR_ENVIO_WS, T13_FECHA_MODIF_ENVIO_WS, T13_COD_ENVIO_WS)");
			query.append(" VALUES(?, ?, SYSDATE, ?, ?, SYSDATE, ?)");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setInt(1, idPeticionEnvio);
			pstmt.setString(2, notice.getSubmissionId());
			pstmt.setString(3, notice.getStatus().name());
			pstmt.setString(4, notice.getReasonCode());
			pstmt.setString(5, notice.getNoDocExt());

			pstmt.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void actualizarEnvioBoletin(Connection connectionOracle, NoticeInformation notice, Integer idPeticionEnvio) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "actualizarEnvioBoletin";
		StringBuffer query = new StringBuffer();
		try {
			query.append("UPDATE AB18A13T00 ");
			query.append("SET T13_FECHA_RECEP_WS = ?, T13_ESTADO_ENVIO_WS = ?, ");
			query.append("T13_ERROR_ENVIO_WS = ?, T13_FECHA_MODIF_ENVIO_WS = ?, ");
			query.append("T13_COD_ENVIO_WS = ? ");
			query.append("WHERE T01_ID_PETICION_ENVIO = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setDate(1, new Date(notice.getReceivedAt().getTime()));
			pstmt.setString(2, notice.getStatus().name());
			pstmt.setString(3, notice.getReasonCode());
			pstmt.setDate(4, new Date(notice.getStatusUpdatedAt().getTime()));
			pstmt.setString(5, notice.getNoDocExt());
			pstmt.setInt(6, idPeticionEnvio);

			pstmt.executeUpdate();
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void actualizarPeticionEnvio(Connection connectionOracle, Map<String, Object> mapaAtributos) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "actualizarEnvioBoletin";
		StringBuffer query = new StringBuffer();
		int contadorParams = 1;
		try {
			query.append("UPDATE AB18A01S00 SET ");
			if (mapaAtributos.get("numIntentos") != null) {
				query.append("T01_NUM_INTENTOS = ?, ");
			} 
			
			if (mapaAtributos.get("idError") != null) {
				query.append("T17_ID_ERROR_VALIDACION = ?, ");
			} 
			query.append("T11_ID_ESTADO = ? ");
			query.append("WHERE T01_ID_PETICION_ENVIO = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			
			if (mapaAtributos.get("numIntentos") != null) {
				Integer idNumIntentos = contadorParams;
				pstmt.setInt(idNumIntentos, (Integer) mapaAtributos.get("numIntentos"));
				contadorParams++;
			} 
			
			if (mapaAtributos.get("idError") != null) {
				Integer idError = contadorParams;
				pstmt.setInt(idError, (Integer) mapaAtributos.get("idError"));
				contadorParams++;
			} 
			pstmt.setInt(contadorParams, (Integer) mapaAtributos.get("idEstado"));
			pstmt.setLong(contadorParams+1, (Integer) mapaAtributos.get("idPeticion"));

			pstmt.executeUpdate();
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void actualizarPeticionResultadoValidacionLogica(Connection connectionOracle, Ab18aPeticionEnvio peticion) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "actualizarEnvioBoletin";
		StringBuffer query = new StringBuffer();
		try {
			query.append("UPDATE AB18A01S00 ");
			query.append("SET T01_RESULT_VALID_LOGICA = ? ");
			query.append("WHERE T01_ID_PETICION_ENVIO = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, peticion.getT01ResultValidLogica());
			pstmt.setLong(2, peticion.getT01IdPeticionEnvio());

			pstmt.executeUpdate();
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void eliminarValidaciones(Connection connectionOracle, Integer idPeticionEnvio) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "eliminarValidaciones";
		StringBuffer query = new StringBuffer();
		try {
			query.append("DELETE FROM AB18A09T00 WHERE T01_ID_PETICION_ENVIO = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setInt(1, idPeticionEnvio);

			pstmt.executeUpdate();
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void almacenarValidaciones(Connection connectionOracle, NoticeInformation notice, Integer idPeticionEnvio) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "almacenarValidaciones";
		StringBuffer query = new StringBuffer();
		query.append("INSERT INTO AB18A09T00 ");
		query.append("(T10_ID_TIPO_VALIDACION, T09_NOMBRE_VALID, T09_SUPERA, T09_SEVERIDAD, ");
		query.append("T09_MENSAJE, T09_DETALLES, T01_ID_PETICION_ENVIO) ");
		query.append("VALUES (?, ?, ?, ?, ?, ?, ?)");

		try {
			List<ValidationReportItem> listaTecnicas = null;
			List<ValidationReportItem> listaValidaciones = null;
			List<ValidationReportItem> listaCalidad = null;

			// Obtenemos las listas de validaciones
			if (notice.getTechnicalValidationReport() != null) {
				listaTecnicas = notice.getTechnicalValidationReport().getItems();
			}

			if (notice.getValidationRulesReport() != null) {
				listaValidaciones = notice.getValidationRulesReport().getItems();
			}

			if (notice.getQualityControlReport() != null) {
				listaCalidad = notice.getQualityControlReport().getItems();
			}

			pstmt = connectionOracle.prepareStatement(query.toString());
			// Comprobamos que las listas no esten vacías
			if (listaTecnicas != null && !listaTecnicas.isEmpty()) {
				for (ValidationReportItem item : listaTecnicas) {
					pstmt.setInt(1, 1);
					pstmt.setString(2, item.getName());
					pstmt.setString(3, item.isValid() ? "T" : "F");
					pstmt.setString(4, item.getSeverity() != null ? item.getSeverity().name() : null);
					pstmt.setString(5, item.getMessage());
					pstmt.setString(6, item.getDetails());
					pstmt.setInt(7, idPeticionEnvio);

					pstmt.addBatch();
				}

				pstmt.executeBatch();
			}

			if (listaValidaciones != null && !listaValidaciones.isEmpty()) {
				for (ValidationReportItem item : listaValidaciones) {
					pstmt.setInt(1, 2);
					pstmt.setString(2, item.getName());
					pstmt.setString(3, item.isValid() ? "T" : "F");
					pstmt.setString(4, item.getSeverity() != null ? item.getSeverity().name() : null);
					pstmt.setString(5, item.getMessage());
					pstmt.setString(6, item.getDetails());
					pstmt.setInt(7, idPeticionEnvio);

					pstmt.addBatch();
				}

				pstmt.executeBatch();
			}

			if (listaCalidad != null && !listaCalidad.isEmpty()) {
				for (ValidationReportItem item : listaCalidad) {
					pstmt.setInt(1, 3);
					pstmt.setString(2, item.getName());
					pstmt.setString(3, item.isValid() ? "T" : "F");
					pstmt.setString(4, item.getSeverity() != null ? item.getSeverity().name() : null);
					pstmt.setString(5, item.getMessage());
					pstmt.setString(6, item.getDetails());
					pstmt.setInt(7, idPeticionEnvio);

					pstmt.addBatch();
				}

				pstmt.executeBatch();
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	/**
	 * Consulta codice originales.
	 * 
	 * @param connectionOracle
	 *            the connection oracle
	 * @return the list
	 * @throws Y46jException
	 *             the y46j exception
	 */
	public List<Ab18aPeticionEnvio> obtenerPeticionesEnvio(Connection connectionOracle) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerPeticionesEnvio";
		List<Ab18aPeticionEnvio> lstPeticiones = new ArrayList<Ab18aPeticionEnvio>();
		Ab18aPeticionEnvio peticionEnvio;
		StringBuffer query = new StringBuffer();
		try {
			query.append("SELECT B.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO, ");
			query.append("B.T02_ID_TIPO_ENVIO T02IDTIPOENVIO, ");
			query.append("B.T06_ID_BOLETIN T06IDBOLETIN, ");
			query.append("B.T11_ID_ESTADO T11IDESTADO, ");
			query.append("B.T01_FECHA_ALTA T01FECHAALTA, ");
			query.append("B.T01_ANUNCIO_ZIP T01ANUNCIOZIP, ");
			query.append("B.T01_ANUNCIO_XML T01ANUNCIOXML, ");
			query.append("B.T01_ID_PODER T01IDPODER, ");
			query.append("B.T01_ID_ENTIDAD_IMP T01IDENTIDADIMP, ");
			query.append("B.T01_ID_ORGANO T01IDORGANO, ");
			query.append("B.T01_ID_ENTIDAD_TRAM T01IDENTIDADTRAM, ");
			query.append("B.T01_ID_MESA T01IDMESA, ");
			query.append("B.T01_FECHA_PROGR_ENVIO T01FECHAPROGRENVIO, ");
			query.append("B.T01_NUM_INTENTOS T01NUMINTENTOS, ");
			query.append("B.T01_DATOS_ERROR T01DATOSERROR, ");
			query.append("B.T01_ESTADO_TRAM T01ESTADOTRAM, ");
			query.append("B.T01_COD_EXPEDIENTE T01CODEXPEDIENTE, ");
			query.append("B.T01_RESULT_VALID_LOGICA T01RESULTVALIDLOGICA, ");
			query.append("B.T01_ANUNCIO_XML_CONVERTIDO T01ANUNCIOXMLCONVERTIDO, ");
			query.append("B.T07_ID_TICKET T07IDTICKET, ");
			query.append("B.T03_ID_APLICACION T03IDAPLICACION ");
			query.append("FROM (SELECT T01_ID_PETICION_ENVIO AS IDPET ");
			query.append("FROM AB18A01S00 V3 INNER JOIN(");
			query.append("(SELECT T01_ID_ORIGEN AS IDORIGEN2, ");
			query.append("T01_FECHA_PROGR_ENVIO AS FECPROGRAMADA2, ");
			query.append("MIN(T01_FECHA_ALTA) AS FECMINIMA ");
			query.append("FROM (SELECT * FROM AB18A01S00 ");
			query.append("WHERE T01_PARALIZADA = 0 AND T11_ID_ESTADO IN (1,6,9) ");
			query.append("AND (T01_NUM_INTENTOS IS NULL ");
			query.append("OR T01_NUM_INTENTOS <= 4)) V2 ");
			query.append("INNER JOIN (SELECT V1.T01_ID_ORIGEN AS IDORIGEN, ");
			query.append("MIN(V1.T01_FECHA_PROGR_ENVIO) AS FECPMINIMA ");
			query.append("FROM (SELECT * FROM AB18A01S00 ");
			query.append("WHERE T01_PARALIZADA = 0 AND T11_ID_ESTADO IN (1,6,9) ");
			query.append("AND (T01_NUM_INTENTOS IS NULL ");
			query.append("OR T01_NUM_INTENTOS <= 4)) V1 ");
			query.append("GROUP BY V1.T01_ID_ORIGEN) SELECTFECP ");
			query.append("ON V2.T01_ID_ORIGEN = SELECTFECP.IDORIGEN ");
			query.append("AND V2.T01_FECHA_PROGR_ENVIO = SELECTFECP.FECPMINIMA ");
			query.append("GROUP BY T01_ID_ORIGEN, T01_FECHA_PROGR_ENVIO)) PRIMERAJOIN ");
			query.append("ON V3.T01_ID_ORIGEN = PRIMERAJOIN.IDORIGEN2 ");
			query.append("AND V3.T01_FECHA_PROGR_ENVIO = PRIMERAJOIN.FECPROGRAMADA2 ");
			query.append("AND V3.T01_FECHA_ALTA = PRIMERAJOIN.FECMINIMA) A, AB18A01S00 B ");
			query.append("WHERE A.IDPET=B.T01_ID_PETICION_ENVIO ");
			query.append("AND (SELECT COUNT(1) FROM AB18A01S00 C ");
			query.append("WHERE C.T03_ID_APLICACION = B.T03_ID_APLICACION ");
			query.append("AND C.T01_ID_ORIGEN = B.T01_ID_ORIGEN ");
			query.append("AND (C.T11_ID_ESTADO =10 ");
			query.append("OR C.T11_ID_ESTADO = 7)) = 0");

			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				peticionEnvio = new Ab18aPeticionEnvio();
				peticionEnvio.setT01IdPeticionEnvio(rs.getInt("T01IDPETICIONENVIO"));
				peticionEnvio.setT02TipoEnvio(rs.getInt("T02IDTIPOENVIO"));
				peticionEnvio.setT06IdBoletin(rs.getInt("T06IDBOLETIN"));
				peticionEnvio.setT11IdEstado(rs.getInt("T11IDESTADO"));
				peticionEnvio.setT01FechaAlta(rs.getDate("T01FECHAALTA"));
				peticionEnvio.setT01NumIntentos(rs.getInt("T01NUMINTENTOS"));
				Clob clob = rs.getClob("T01ANUNCIOXML");
				peticionEnvio.setT01AnuncioXml(clob.getSubString(1, (int) clob.length()));
				lstPeticiones.add(peticionEnvio);
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);

		}
		return lstPeticiones;
	}

	public List<Ab18aRespuestaWS> obtenerPeticionesRecogida(Connection connectionOracle) throws Ab18aException {

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerPeticionesEnvio";
		List<Ab18aRespuestaWS> lstRespuesta = new ArrayList<Ab18aRespuestaWS>();
		Ab18aRespuestaWS respuestaWS;
		StringBuffer query = new StringBuffer();
		try {
			query.append("SELECT D.T13_ID_ENVIO_WS T13IDENVIOWS, D.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO FROM AB18A13S00 D INNER JOIN (");
			query.append("SELECT B.T01_ID_PETICION_ENVIO T01IDPETICIONENVIO ");
			query.append("FROM (SELECT T01_ID_PETICION_ENVIO AS IDPET ");
			query.append("FROM AB18A01S00 V3 INNER JOIN(");
			query.append("(SELECT T01_ID_ORIGEN AS IDORIGEN2, ");
			query.append("T01_FECHA_PROGR_ENVIO AS FECPROGRAMADA2, ");
			query.append("MIN(T01_FECHA_ALTA) AS FECMINIMA ");
			query.append("FROM (SELECT * FROM AB18A01S00 ");
			query.append("WHERE T11_ID_ESTADO IN (7,9,10,11) ");
			query.append("AND (T01_NUM_INTENTOS IS NULL ");
			query.append("OR T01_NUM_INTENTOS <= 4)) V2 ");
			query.append("INNER JOIN (SELECT V1.T01_ID_ORIGEN AS IDORIGEN, ");
			query.append("MIN(V1.T01_FECHA_PROGR_ENVIO) AS FECPMINIMA ");
			query.append("FROM (SELECT * FROM AB18A01S00 ");
			query.append("WHERE T11_ID_ESTADO IN (7,9,10,11) ");
			query.append("AND (T01_NUM_INTENTOS IS NULL ");
			query.append("OR T01_NUM_INTENTOS <= 4)) V1 ");
			query.append("GROUP BY V1.T01_ID_ORIGEN) SELECTFECP ");
			query.append("ON V2.T01_ID_ORIGEN = SELECTFECP.IDORIGEN ");
			query.append("AND V2.T01_FECHA_PROGR_ENVIO = SELECTFECP.FECPMINIMA ");
			query.append("GROUP BY T01_ID_ORIGEN, T01_FECHA_PROGR_ENVIO)) PRIMERAJOIN ");
			query.append("ON V3.T01_ID_ORIGEN = PRIMERAJOIN.IDORIGEN2 ");
			query.append("AND V3.T01_FECHA_PROGR_ENVIO = PRIMERAJOIN.FECPROGRAMADA2 ");
			query.append("AND V3.T01_FECHA_ALTA = PRIMERAJOIN.FECMINIMA) A, AB18A01S00 B ");
			query.append("WHERE A.IDPET=B.T01_ID_PETICION_ENVIO ");
			query.append("AND (SELECT COUNT(1) FROM AB18A01S00 C ");
			query.append("WHERE C.T03_ID_APLICACION = B.T03_ID_APLICACION ");
			query.append("AND C.T01_ID_ORIGEN = B.T01_ID_ORIGEN ");
			query.append("AND (C.T11_ID_ESTADO =10 ");
			query.append("OR C.T11_ID_ESTADO = 12 OR C.T11_ID_ESTADO = 13)) = 0) E ON D.T01_ID_PETICION_ENVIO = E.T01IDPETICIONENVIO");
			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				respuestaWS = new Ab18aRespuestaWS();
				respuestaWS.setT13IdEnvioWs(rs.getString("T13IDENVIOWS"));
				respuestaWS.setT01IdPeticionEnvio(rs.getLong("T01IDPETICIONENVIO"));
				lstRespuesta.add(respuestaWS);
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);

		}
		return lstRespuesta;
	}

	public void insertarDatosPublicacion(Connection connectionOracle, PublicationInfo publicationInfo, int idPeticion) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "insertarDatosPublicacion";
		StringBuffer query = new StringBuffer();
		try {

			query.append("INSERT INTO AB18A14T00");
			query.append("(T01_ID_PETICION_ENVIO, T14_ID_PUBLICACION_WS");
			query.append(", T14_FECHA_PUBLICACION_WS, T14_COD_DOC_PUBLICACION_WS)");
			query.append(" VALUES(?, ?, ?, ?)");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setInt(1, idPeticion);
			pstmt.setString(2, publicationInfo.getNoDocOjs());
			pstmt.setDate(3, new Date(publicationInfo.getPublicationDate().getTime()));
			pstmt.setString(4, publicationInfo.getOjsNumber());

			pstmt.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public void insertarTedLinks(Connection connectionOracle, String link, int idPeticion) throws Ab18aException {
		PreparedStatement pstmt = null;
		String nombre_metodo = "insertarDatosPublicacion";
		StringBuffer query = new StringBuffer();
		try {

			query.append("INSERT INTO AB18A08T00 ");
			query.append("(T08_LINK, ");
			query.append("T01_ID_PETICION_ENVIO)");
			query.append(" VALUES(?, ?)");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, link);
			pstmt.setInt(2, idPeticion);

			pstmt.executeUpdate();
		} catch (Exception e) {
			e.printStackTrace();
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}

	public List<Ab18aPlantillasXSLT> obtenerPlantillasXSLT(Connection connectionOracle, String[] versionSubversionPlantilla) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerFicherosValidacionPeticionEnvio";
		List<Ab18aPlantillasXSLT> lstPlantillas = new ArrayList<Ab18aPlantillasXSLT>();
		Ab18aPlantillasXSLT plantillaXSLT;
		StringBuffer query = new StringBuffer();

		try {
			query.append("SELECT T05_COD_PLANTILLA_VALID, ");
			query.append("T05_ID_PLANTILLA_VALID, ");
			query.append("T05_PLANTILLA_VALID, ");
			query.append("T05_RUTA_PLANTILLA_VALID ");
			query.append(" FROM AB18A05T00");
			query.append(" WHERE T05_FECHA_BAJA IS NULL");
			query.append(" AND T05_COD_PLANTILLA_VALID = '").append(Ab18aPropertiesBatchManager.getProperty(Ab18aConstantes.DOUE_XSL_PRINCIPAL))
					.append("'");
			query.append(" AND T05_RUTA_PLANTILLA_VALID LIKE '").append("%").append(versionSubversionPlantilla[0]).append("%")
					.append(versionSubversionPlantilla[1]).append("%").append("'");

			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				plantillaXSLT = new Ab18aPlantillasXSLT();
				plantillaXSLT.setT05CodPlantillaValid(rs.getString("T05_COD_PLANTILLA_VALID"));
				plantillaXSLT.setT05IdPlantillaValid(rs.getLong("T05_ID_PLANTILLA_VALID"));
				plantillaXSLT.setT05PlantillaValid(rs.getClob("T05_PLANTILLA_VALID"));
				plantillaXSLT.setT05RutaPlantillaValid(rs.getString("T05_RUTA_PLANTILLA_VALID"));
				lstPlantillas.add(plantillaXSLT);
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		return lstPlantillas;
	}

	public Map<Integer, Ab18aConfiguracionAplicacion> obtenerFlagsConfiguracion(Connection connectionOracle) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerFlagsConfiguracion";
		Map<Integer, Ab18aConfiguracionAplicacion> mapConfiguracionAplicacion = new HashMap<Integer, Ab18aConfiguracionAplicacion>();
		Ab18aConfiguracionAplicacion configuracionAplicacion;
		StringBuffer query = new StringBuffer();

		try {
			query.append("SELECT T00_ID_CONF_APLIC, ");
			query.append("T00_DESC_ES, ");
			query.append("T00_DESC_EU, ");
			query.append("T00_VALOR ");
			query.append(" FROM AB18A00T00");

			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				configuracionAplicacion = new Ab18aConfiguracionAplicacion();
				configuracionAplicacion.setT00DescEs(rs.getString("T00_DESC_ES"));
				configuracionAplicacion.setT00DescEu(rs.getString("T00_DESC_EU"));
				configuracionAplicacion.setT00IdConfiguracionAplicacion(rs.getInt("T00_ID_CONF_APLIC"));
				configuracionAplicacion.setT00Valor(rs.getInt("T00_VALOR") == 1 ? true : false);
				mapConfiguracionAplicacion.put(configuracionAplicacion.getT00IdConfiguracionAplicacion(), configuracionAplicacion);
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		return mapConfiguracionAplicacion;
	}
	
	public Integer obtenerEstadoPeticion(Connection connectionOracle, Integer idPeticionEnvio) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerEstadoPeticion";
		StringBuffer query = new StringBuffer();
		Integer estadoActual = 0;
		try {
			query.append("SELECT T11_ID_ESTADO T11ESTADO");
			query.append(" FROM AB18A01S00 WHERE T01_ID_PETICION_ENVIO = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setInt(1, idPeticionEnvio);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				estadoActual = rs.getInt("T11ESTADO");
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		return estadoActual;
	}
	
	public Integer obtenerIdErrorEsentool(Connection connectionOracle, String codError) throws Ab18aException {
		Integer idErrorEsentool = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerIdErrorEsentool";
		StringBuffer query = new StringBuffer();
		try {
			query.append("SELECT T17_ID_ERROR_VALIDACION T17IDERROR");
			query.append(" FROM AB18A17S00 WHERE T17_COD_ERROR_VALIDACION = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, codError);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				idErrorEsentool = rs.getInt("T17IDERROR");
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		return idErrorEsentool;
	}
	
	public List<String> obtenerExpedientes(Connection connectionOracle) throws Ab18aException {
		List<String> listaExpedientes = new ArrayList<String>();
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerExpedientes";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT DISTINCT T01_COD_EXPEDIENTE T01CODEXP");
			query.append(" FROM AB18A01S00 WHERE T11_ID_ESTADO = 12 AND T01_ESTADO_TRAM IN (1,5)");

			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				listaExpedientes.add(rs.getString("T01CODEXP")); 
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return listaExpedientes;
	}
	
	public boolean obtenerAnuncioExpediente(Connection connectionOracle, String expediente, Integer estadoTramitacion) throws Ab18aException {
		Integer countAnuncio = 0;
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String nombre_metodo = "obtenerAnuncioExpediente";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT CASE WHEN EXISTS(SELECT T01_ID_PETICION_ENVIO FROM AB18A01S00 WHERE T01_COD_EXPEDIENTE = ? AND T01_ESTADO_TRAM = ? AND T11_ID_ESTADO = 12) THEN 1 ELSE 0 END FROM DUAL");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, expediente);
			pstmt.setInt(2, estadoTramitacion);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				countAnuncio = rs.getInt(1);
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarRS(rs);
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return (countAnuncio > 0);
	}
	
	public void insertarIncoherencia(Connection connectionOracle, String expediente, Integer tipoIncoherencia) throws Ab18aException {
		PreparedStatement pstmt = null;
		int rs = 0;
		String nombre_metodo = "insertarIncoherencia";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("INSERT INTO AB18A18S00 (T18_COD_EXPEDIENTE, T18_ID_TIPO_INCOHERENCIA) VALUES (?, ?)");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, expediente);
			pstmt.setInt(2, tipoIncoherencia);
			rs = Ab18aSentenciaOracle.ejecutarPSTMT(pstmt);
			Ab18aConexionOracle.commit(connectionOracle);
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}
	
	public void updateIncoherencia(Connection connectionOracle, Ab18aIncoherencia incoherencia) throws Ab18aException {
		PreparedStatement pstmt = null;
		int rs = 0;
		String nombre_metodo = "updateIncoherencia";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("UPDATE AB18A18S00 SET T18_FECHA_BAJA = CURRENT_TIMESTAMP WHERE T18_ID_INCOHERENCIA = ?");
			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setInt(1, incoherencia.getIdIncoherencia());
			rs = Ab18aSentenciaOracle.ejecutarPSTMT(pstmt);
			Ab18aConexionOracle.commit(connectionOracle);
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
	}
	
	public Integer findIncoherenciaByExpediente(Connection connectionOracle, String expediente) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int idIncoherencia = 0;
		String nombre_metodo = "findIncoherenciaByExpediente";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT T18_ID_INCOHERENCIA T18IDINCO FROM AB18A18S00 WHERE T18_COD_EXPEDIENTE = ? AND T18_FECHA_BAJA IS NULL");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, expediente);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				idIncoherencia = rs.getInt("T18IDINCO");
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return idIncoherencia;
	}
	
	public Integer findIncoherenciaByExpedienteBaja(Connection connectionOracle, String expediente) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int idIncoherencia = 0;
		String nombre_metodo = "findIncoherenciaByExpediente";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT T18_ID_INCOHERENCIA T18IDINCO FROM AB18A18S00 WHERE T18_COD_EXPEDIENTE = ?");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, expediente);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				idIncoherencia = rs.getInt("T18IDINCO");
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return idIncoherencia;
	}
	
	public Integer obtenerPlazoIncoherencia(Connection connectionOracle) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int plazoIncoherencia = 0;
		String nombre_metodo = "obtenerPlazoIncoherencia";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT T00_VALOR T00VALOR FROM AB18A00S00 WHERE T00_ID_CONF_APLIC = 5");

			pstmt = connectionOracle.prepareStatement(query.toString());
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				plazoIncoherencia = rs.getInt("T00VALOR");
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return plazoIncoherencia;
	}
	
	public java.util.Date obtenerFechaAltaExpediente(Connection connectionOracle, String expediente) throws Ab18aException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		java.util.Date fechaAlta = null;
		String nombre_metodo = "obtenerFechaAltaExpediente";
		StringBuffer query = new StringBuffer();
		
		try {
			query.append("SELECT T14.T14_FECHA_PUBLICACION_WS T14FECHAPUBLI FROM AB18A01S00 T1 INNER JOIN AB18A14S00 T14 ON T1.T01_ID_PETICION_ENVIO = T14. T01_ID_PETICION_ENVIO WHERE T1.T01_COD_EXPEDIENTE = ? AND T1.T01_ESTADO_TRAM = 1 AND T1.T11_ID_ESTADO = 12");

			pstmt = connectionOracle.prepareStatement(query.toString());
			pstmt.setString(1, expediente);
			rs = Ab18aSentenciaOracle.consultarPSTMT(pstmt);
			while (rs.next()) {
				fechaAlta = new Date(rs.getDate("T14FECHAPUBLI").getTime());
			}
		} catch (Exception e) {
			throw new Ab18aException(Ab18aRealizarProcesoBD.class.getName(), nombre_metodo, e);
		} finally {
			Ab18aSentenciaOracle.cerrarPSTMT(pstmt);
		}
		
		return fechaAlta;
	}
}
